<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Storage;

class DatabaseController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'role:admin']); // only admins
    }

    // Show backup/restore page
    public function index()
    {
        $backups = Storage::disk('backups')->files();
        return view('settings.database', compact('backups'));
    }

    // Manual backup
    public function backup()
    {
        $filename = 'backup_' . date('Y-m-d_H-i-s') . '.sql';
        $path = storage_path("app/backups/{$filename}");

        $db = config('database.connections.mysql');

        // Make sure mysqldump path is set if on Windows
        $dumpPath = isset($db['dump']['dump_binary_path']) ? $db['dump']['dump_binary_path'] : 'mysqldump';

        $command = "{$dumpPath} --user={$db['username']} --password={$db['password']} --host={$db['host']} {$db['database']} > {$path}";

        $returnVar = null;
        $output = null;
        exec($command, $output, $returnVar);

        if ($returnVar === 0) {
            return redirect()->back()->with('success', "Backup created: {$filename}");
        } else {
            return redirect()->back()->with('error', "Backup failed! Check server permissions or mysqldump path.");
        }
    }

    // Restore backup
    public function restore(Request $request)
    {
        $request->validate([
            'backup_file' => 'required|file|mimes:sql',
        ]);

        $file = $request->file('backup_file')->getPathName();
        $db = config('database.connections.mysql');

        $command = "mysql --user={$db['username']} --password={$db['password']} --host={$db['host']} {$db['database']} < {$file}";

        $returnVar = null;
        $output = null;
        exec($command, $output, $returnVar);

        if ($returnVar === 0) {
            return redirect()->back()->with('success', "Database restored successfully.");
        } else {
            return redirect()->back()->with('error', "Restore failed! Check the SQL file and permissions.");
        }
    }

    // Save scheduled backup interval
    public function schedule(Request $request)
    {
        $request->validate([
            'interval' => 'required|in:hourly,daily,weekly,none',
        ]);

        // Store in DB or config file for scheduler to read
        config(['database.backup_interval' => $request->interval]);

        return redirect()->back()->with('success', "Backup schedule updated.");
    }
}
