<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class DatabaseBackup extends Command
{
    /**
     * The name and signature of the console command.
     *
     * You can run it manually with: php artisan db:backup
     *
     * @var string
     */
    protected $signature = 'db:backup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create a database backup and store it in storage/app/backups';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $db = config('database.connections.mysql');

        // Backup file name with timestamp
        $filename = 'backup_' . date('Y-m-d_H-i-s') . '.sql';
        $backupPath = storage_path("app/backups/{$filename}");

        // Ensure the backups folder exists
        if (!file_exists(storage_path('app/backups'))) {
            mkdir(storage_path('app/backups'), 0755, true);
        }

        // mysqldump command
        $command = "mysqldump --user={$db['username']} --password={$db['password']} --host={$db['host']} {$db['database']} > {$backupPath}";

        // Execute the command
        exec($command, $output, $returnVar);

        if ($returnVar === 0) {
            $this->info("Database backup created successfully: {$filename}");
            return Command::SUCCESS;
        } else {
            $this->error("Backup failed. Check your database credentials and permissions.");
            return Command::FAILURE;
        }
    }
}
